#!/usr/bin/env python3

import sys
from datetime import datetime
from dateutil.relativedelta import relativedelta

if len(sys.argv) != 2:
    print("Usage: python age_calculator.py MM/DD/YY")
    sys.exit(1)

date_str = sys.argv[1]
try:
    date = datetime.strptime(date_str, "%m/%d/%y")
except ValueError:
    print("Invalid date format. Use MM/DD/YY")
    sys.exit(1)

date_18 = date + relativedelta(months=18)
date_30 = date + relativedelta(months=30)

print(f"18 months from {date_str}: {date_18.strftime('%m/%d/%y')}")
print(f"30 months from {date_str}: {date_30.strftime('%m/%d/%y')}")